
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Frank's Investment")

# Create variables
x1 = m.addVar(nonnegative=True, name="cigarette_investment") # dollars invested in cigarette industry
x2 = m.addVar(nonnegative=True, name="tobacco_investment") # dollars invested in tobacco industry

# Set objective function
m.setObjective(0.30 * x1 + 0.45 * x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 <= 5000, "Total investment")
m.addConstr(x1 >= 0.4 * (x1 + x2), "Cigarette investment proportion")
m.addConstr(x2 >= 1000, "Minimum tobacco investment")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal investment strategy:")
    print(f"Invest ${x1.x:.2f} in the cigarette industry")
    print(f"Invest ${x2.x:.2f} in the tobacco industry")
    print(f"Maximum profit: ${m.objVal:.2f}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

