
from gurobipy import *

# Create a new model
m = Model("Frank_Investment")

# Define variables
x1 = m.addVar(lb=0, name="cigarette_investment")
x2 = m.addVar(lb=0, name="tobacco_investment")

# Set the objective function
m.setObjective(0.30*x1 + 0.45*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 <= 5000, "total_investment")
m.addConstr(x1 >= 0.4*(x1 + x2), "cigarette_percentage")
m.addConstr(x2 >= 1000, "tobacco_minimum")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Cigarette Investment: {x1.x}")
    print(f"Tobacco Investment: {x2.x}")
    print(f"Total Profit: {m.objVal}")
else:
    print("No optimal solution found")
