
import gurobipy as gp

# Create a new model
model = gp.Model("Investment_Problem")

# Define variables
x1 = model.addVar(name="cigarette_investment", lb=0)  # Investment in cigarette industry
x2 = model.addVar(name="tobacco_investment", lb=0)   # Investment in tobacco industry

# Objective function: Maximize profit
model.setObjective(0.30*x1 + 0.45*x2, gp.GRB.MAXIMIZE)

# Constraints
model.addConstr(x1 + x2 <= 5000, name="total_investment")
model.addConstr(x1 >= 0.4*(x1 + x2), name="cigarette_proportion")
model.addConstr(x2 >= 1000, name="tobacco_min_investment")

# Solve the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal investment in cigarette industry: ${x1.varValue}")
    print(f"Optimal investment in tobacco industry: ${x2.varValue}")
    print(f"Maximal profit: ${0.30*x1.varValue + 0.45*x2.varValue}")
else:
    print("The model is infeasible.")
