
import gurobipy as gp

# Create a new model
m = gp.Model("woodshop")

# Create variables
chairs = m.addVar(vtype=gp.GRB.INTEGER, name="chairs")
nightstands = m.addVar(vtype=gp.GRB.INTEGER, name="nightstands")

# Set objective function
m.setObjective(300 * chairs + 500 * nightstands, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(2 * chairs + 5 * nightstands <= 30, "John's time")
m.addConstr(4 * chairs + 4 * nightstands <= 40, "William's time")
m.addConstr(chairs >=0)
m.addConstr(nightstands >= 0)


# Optimize model
m.optimize()

if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution found: Make {chairs.x} chairs and {nightstands.x} nightstands")
    print(f"Optimal profit: ${m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

