
from gurobipy import *

# Create a new model
model = Model("Woodshop_Problem")

# Define variables
x1 = model.addVar(lb=0, vtype=GRB.INTEGER, name="chairs")
x2 = model.addVar(lb=0, vtype=GRB.INTEGER, name="nightstands")

# Set the objective function
model.setObjective(300*x1 + 500*x2, GRB.MAXIMIZE)

# Add constraints
model.addConstr(2*x1 + 5*x2 <= 30, "John's_time")
model.addConstr(4*x1 + 4*x2 <= 40, "William's_time")

# Optimize the model
model.optimize()

# Print the solution
if model.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of chairs: {x1.x}")
    print(f"Number of nightstands: {x2.x}")
    print(f"Maximum profit: ${300*x1.x + 500*x2.x}")
else:
    print("No optimal solution found")
