
import gurobipy as gp

# Create a new model
model = gp.Model("Woodshop_Optimization")

# Define the variables
x1 = model.addVar(name="chairs", lb=0, vtype=gp.GRB.INTEGER)  # Number of chairs
x2 = model.addVar(name="nightstands", lb=0, vtype=gp.GRB.INTEGER)  # Number of nightstands

# Define the objective function
model.setObjective(300*x1 + 500*x2, gp.GRB.MAXIMIZE)

# Define the constraints
model.addConstr(2*x1 + 5*x2 <= 30, name="John's_time_constraint")
model.addConstr(4*x1 + 4*x2 <= 40, name="William's_time_constraint")

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal number of chairs: {x1.varValue}")
    print(f"Optimal number of nightstands: {x2.varValue}")
    print(f"Maximum profit: {model.objVal}")
else:
    print("The model is infeasible.")
