
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("apple_production")

# Create variables
x1 = m.addVar(name="Granny_Smith") # kg of Granny Smith apples
x2 = m.addVar(name="McIntosh") # kg of McIntosh apples


# Set objective function
m.setObjective(2*x1 + x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 <= 100, "Granny_Smith_max")
m.addConstr(x2 <= 120, "McIntosh_max")
m.addConstr(x1 >= 25, "Granny_Smith_min")
m.addConstr(x2 >= 50, "McIntosh_min")
m.addConstr(3*x1 + 3*x2 <= 15, "Cleaning_machine_time")


# Optimize model
m.optimize()

if m.status == GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal}")
    print(f"Granny Smith apples: {x1.x} kg")
    print(f"McIntosh apples: {x2.x} kg")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

