
import gurobipy as gp

# Create a new model
model = gp.Model("AppleFarm")

# Define variables
x1 = model.addVar(lb=25, ub=100, name="GrannySmith")
x2 = model.addVar(lb=50, ub=120, name="McIntosh")

# Objective function: maximize profit
model.setObjective(2*x1 + x2, gp.GRB.MAXIMIZE)

# Constraints
model.addConstr(x1 <= 100, name="GrannySmithLimit")
model.addConstr(x2 <= 120, name="McIntoshLimit")
model.addConstr(x1 >= 25, name="GrannySmithMin")
model.addConstr(x2 >= 50, name="McIntoshMin")
model.addConstr(3*x1 + 3*x2 <= 15, name="CleaningMachineLimit")

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Granny Smith apples: {x1.varValue} kg")
    print(f"McIntosh apples: {x2.varValue} kg")
    print(f"Max Profit: ${model.objVal}")
else:
    print("No optimal solution found.")
