
import gurobipy as gp

# Create a new model
m = gp.Model("nut_farm")

# Create variables
almonds = m.addVar(nonneg=True, name="almonds")  # Acres of almonds
pecans = m.addVar(nonneg=True, name="pecans")  # Acres of pecans

# Set objective function
m.setObjective(500 * almonds + 600 * pecans, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(almonds + pecans <= 80, "land")  # Land constraint
m.addConstr(1.5 * almonds + 3 * pecans <= 275, "labor")  # Labor constraint
m.addConstr(200 * almonds + 250 * pecans <= 10000, "maintenance")  # Maintenance cost constraint

# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal net revenue: ${m.objVal:.2f}")
    print(f"Acres of almonds: {almonds.x:.2f}")
    print(f"Acres of pecans: {pecans.x:.2f}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

