
from gurobipy import *

# Create a new model
m = Model("Nut_Farmer_Optimization")

# Define the variables
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="acres_of_almonds")
x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="acres_of_pecans")

# Set the objective function
m.setObjective(500*x1 + 600*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(1.5*x1 + 3*x2 <= 275, "labor_constraint")
m.addConstr(200*x1 + 250*x2 <= 10000, "maintenance_cost_constraint")
m.addConstr(x1 + x2 <= 80, "total_land_constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Acres of almonds: {x1.x}")
    print(f"Acres of pecans: {x2.x}")
    print(f"Maximum net revenue: {m.objVal}")
else:
    print("No optimal solution found")
