
import gurobipy as gp

# Create a new model
model = gp.Model("NutFarmer")

# Define variables
x1 = model.addVar(name="almonds", lb=0)  # acres of almonds
x2 = model.addVar(name="pecans", lb=0)   # acres of pecans

# Objective function: maximize net revenue
model.setObjective(500*x1 + 600*x2, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(x1 + x2 <= 80, name="land_constraint")
model.addConstr(1.5*x1 + 3*x2 <= 275, name="labor_constraint")
model.addConstr(200*x1 + 250*x2 <= 10000, name="maintenance_cost_constraint")

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal acres of almonds: {x1.varValue}")
    print(f"Optimal acres of pecans: {x2.varValue}")
    print(f"Maximal net revenue: {model.objVal}")
else:
    print("The model is infeasible.")
