
import gurobipy as gp

# Create a new model
m = gp.Model("milk_tea_toppings")

# Create variables
red_bean = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="red_bean") # Although we expect integer solutions, using continuous relaxation can sometimes be faster and still yield integer solutions in this case. If not, switch to GRB.INTEGER
pudding = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="pudding")

# Set objective function
m.setObjective(1.5 * red_bean + 2 * pudding, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(red_bean <= 3, "max_red_bean")
m.addConstr(1.5 * red_bean + 3 * pudding >= 7, "min_sugar")
m.addConstr(2.5 * red_bean + 1.2 * pudding >= 10, "min_butter")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal cost: ${m.objVal}")
    print(f"Red bean toppings: {red_bean.x}")
    print(f"Pudding toppings: {pudding.x}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

