
from gurobipy import *

# Create a new model
m = Model("Milk_Tea_Optimization")

# Define variables
x1 = m.addVar(lb=0, vtype=GRB.INTEGER, name="red_bean_toppings")
x2 = m.addVar(lb=0, vtype=GRB.INTEGER, name="pudding_toppings")

# Set the objective function
m.setObjective(1.5*x1 + 2*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(x1 <= 3, "max_red_bean")
m.addConstr(1.5*x1 + 3*x2 >= 7, "min_sugar")
m.addConstr(2.5*x1 + 1.2*x2 >= 10, "min_butter")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print("Red bean toppings:", x1.x)
    print("Pudding toppings:", x2.x)
    print("Minimum cost:", m.objVal)
else:
    print("No optimal solution found")
