
import gurobi

def solve_milk_tea_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(lb=0, name="red_bean_toppings")
    x2 = model.addVar(lb=0, name="pudding_toppings")

    # Objective function: minimize 1.5*x1 + 2*x2
    model.setObjective(1.5 * x1 + 2 * x2, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(x1 <= 3, name="red_bean_limit")
    model.addConstr(1.5 * x1 + 3 * x2 >= 7, name="sugar_requirement")
    model.addConstr(2.5 * x1 + 1.2 * x2 >= 10, name="butter_requirement")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Red bean toppings: {x1.varValue}")
        print(f"Pudding toppings: {x2.varValue}")
        print(f"Cost: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_milk_tea_problem()
