
import gurobipy as gp

# Create a new model
m = gp.Model("Toms_Shooting_Game")

# Create variables
slow_shots = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="slow_shots")
quick_shots = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="quick_shots")


# Set objective function
m.setObjective(3 * slow_shots + 6 * quick_shots, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(slow_shots + quick_shots <= 20, "total_shots")
m.addConstr(slow_shots >= 8, "min_slow_shots")
m.addConstr(quick_shots >= 5, "min_quick_shots")
m.addConstr(slow_shots <= 12, "max_slow_shots")
m.addConstr(quick_shots <= 12, "max_quick_shots")


# Optimize model
m.optimize()

if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal score: {m.objVal}")
    print(f"Number of slow shots: {slow_shots.x}")
    print(f"Number of quick shots: {quick_shots.x}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

