
from gurobipy import *

# Create a model
m = Model("Tom_Shots")

# Define variables
x1 = m.addVar(lb=8, ub=12, vtype=GRB.INTEGER, name="slow_shots")
x2 = m.addVar(lb=5, ub=12, vtype=GRB.INTEGER, name="quick_shots")

# Set the objective function
m.setObjective(3*x1 + 6*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 <= 20, "total_shots")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Slow shots: {x1.x}")
    print(f"Quick shots: {x2.x}")
    print(f"Total score: {3*x1.x + 6*x2.x}")
else:
    print("No optimal solution found")
