
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(lb=0, ub=None, name="slow_shots", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(lb=0, ub=None, name="quick_shots", vtype=gurobi.GRB.INTEGER)

    # Set bounds according to constraints
    x1.lb = 8
    x2.lb = 5
    x1.ub = 12
    x2.ub = 12

    # Objective function
    model.setObjective(3 * x1 + 6 * x2, gurobi.GRB.MAXIMIZE)

    # Additional constraint: x1 + x2 <= 20
    model.addConstr(x1 + x2 <= 20)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Slow shots: {x1.varValue}")
        print(f"Quick shots: {x2.varValue}")
        print(f"Max score: {3 * x1.varValue + 6 * x2.varValue}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
