
from gurobipy import Model, GRB

# Create a new model
m = Model("appliance_store")

# Create variables
microwaves = m.addVar(vtype=GRB.INTEGER, name="microwaves")
vents = m.addVar(vtype=GRB.INTEGER, name="vents")

# Set objective function
m.setObjective(200 * microwaves + 300 * vents, GRB.MAXIMIZE)

# Add constraints
m.addConstr(300 * microwaves + 400 * vents <= 20000, "budget_constraint")
m.addConstr(microwaves >= 30, "min_microwaves")
m.addConstr(microwaves <= 65, "max_microwaves")
m.addConstr(vents <= (1/3) * microwaves, "vent_limit")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal}")
    print(f"Number of microwaves to sell: {microwaves.x}")
    print(f"Number of vents to sell: {vents.x}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

