
from gurobipy import *

# Create a new model
m = Model("Appliance_Store_Optimization")

# Define variables
x1 = m.addVar(vtype=GRB.INTEGER, name="microwaves")
x2 = m.addVar(vtype=GRB.INTEGER, name="vents")

# Set objective function
m.setObjective(200*x1 + 300*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(300*x1 + 400*x2 <= 20000, "budget")
m.addConstr(x1 >= 30, "min_microwaves")
m.addConstr(x1 <= 65, "max_microwaves")
m.addConstr(x2 <= (1/3)*x1, "vent_limit")
m.addConstr(x1 >= 0, "non_negative_microwaves")
m.addConstr(x2 >= 0, "non_negative_vents")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of microwaves to sell: {x1.x}")
    print(f"Number of vents to sell: {x2.x}")
    print(f"Maximum profit: {m.objVal}")
else:
    print("No optimal solution found")
