
import gurobipy as gp

def solve_optimization_problem():
    # Create a new model
    model = gp.Model("appliance_store")

    # Define variables
    x1 = model.addVar(lb=30, ub=65, name="microwaves", vtype=gp.GRB.INTEGER)
    x2 = model.addVar(name="vents", vtype=gp.GRB.INTEGER)

    # Objective function: Maximize profit
    model.setObjective(200*x1 + 300*x2, gp.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(300*x1 + 400*x2 <= 20000, name="budget_constraint")
    model.addConstr(x2 <= (1/3)*x1, name="vent_microwave_ratio")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gp.GRB.OPTIMAL:
        print(f"Optimal solution: Microwaves = {x1.varValue}, Vents = {x2.varValue}")
        print(f"Maximum profit: ${200*x1.varValue + 300*x2.varValue}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
