
import gurobipy as gp

# Create a new model
m = gp.Model("smoothie_optimization")

# Create variables
x1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="blueberry_smoothies") # Number of blueberry smoothies
x2 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="chocolate_smoothies") # Number of chocolate smoothies


# Set objective function
m.setObjective(2*x1 + 3*x2, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(3*x1 + 5*x2 <= 1000, "preparation_time") # Preparation time constraint
m.addConstr(2*x1 + 1*x2 <= 750, "blending_time") # Blending time constraint


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution found. Objective value: {m.objVal}")
    print(f"Number of blueberry smoothies: {x1.x}")
    print(f"Number of chocolate smoothies: {x2.x}")
elif m.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

