
from gurobipy import *

# Create a new model
m = Model("Smoothies_Optimization")

# Define variables
x1 = m.addVar(name='blueberry_smoothies', vtype=GRB.CONTINUOUS, lb=0)
x2 = m.addVar(name='chocolate_smoothies', vtype=GRB.CONTINUOUS, lb=0)

# Set the objective function
m.setObjective(2*x1 + 3*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(3*x1 + 5*x2 <= 1000, name='preparation_time')
m.addConstr(2*x1 + x2 <= 750, name='blending_time')

# Optimize the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of blueberry smoothies: {x1.x}")
    print(f"Number of chocolate smoothies: {x2.x}")
    print(f"Maximum profit: {m.objVal}")
else:
    print("No optimal solution found")
