
import gurobi

def solve_smoothie_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="blueberry_smoothies", lb=0, vtype=gurobi.GRB.CONTINUOUS)
    x2 = model.addVar(name="chocolate_smoothies", lb=0, vtype=gurobi.GRB.CONTINUOUS)

    # Objective function: Maximize 2*x1 + 3*x2
    model.setObjective(2*x1 + 3*x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(3*x1 + 5*x2 <= 1000, name="preparation_time")
    model.addConstr(2*x1 + x2 <= 750, name="blending_time")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: x1 = {x1.varValue}, x2 = {x2.varValue}")
        print(f"Maximum profit: {model.objVal}")
    else:
        print("The model is infeasible")

solve_smoothie_problem()
