
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("shampoo_conditioner")

# Create variables
shampoo = m.addVar(lb=0, vtype=GRB.INTEGER, name="shampoo")
conditioner = m.addVar(lb=0, vtype=GRB.INTEGER, name="conditioner")

# Set objective function
m.setObjective(5 * shampoo + 6 * conditioner, GRB.MAXIMIZE)

# Add constraints
m.addConstr(3 * shampoo + 4 * conditioner <= 300, "time_constraint")
m.addConstr(shampoo >= 50, "shampoo_min")
m.addConstr(conditioner >= 30, "conditioner_min")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal:.2f}")
    print(f"Shampoo bottles: {shampoo.x}")
    print(f"Conditioner bottles: {conditioner.x}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

