
from gurobipy import *

# Create a new model
m = Model("Shampoo_Conditioner_Optimization")

# Create variables
x1 = m.addVar(lb=50, vtype=GRB.INTEGER, name="shampoo_bottles")
x2 = m.addVar(lb=30, vtype=GRB.INTEGER, name="conditioner_bottles")

# Set the objective function
m.setObjective(5*x1 + 6*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(3*x1 + 4*x2 <= 300, "time_constraint")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution: {x1.varName} = {x1.x}, {x2.varName} = {x2.x}")
    print(f"Maximum profit: {m.objVal}")
else:
    print("No optimal solution found")
