
import gurobi

def solve_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(lb=50, name="shampoo_bottles")  # at least 50 shampoo bottles
    x2 = model.addVar(lb=30, name="conditioner_bottles")  # at least 30 conditioner bottles

    # Define the objective function
    model.setObjective(5 * x1 + 6 * x2, gurobi.GRB.MAXIMIZE)

    # Define the constraints
    model.addConstr(3 * x1 + 4 * x2 <= 300, name="time_constraint")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Number of shampoo bottles: {x1.varValue}")
        print(f"Number of conditioner bottles: {x2.varValue}")
        print(f"Max profit: {5 * x1.varValue + 6 * x2.varValue}")
    else:
        print("No optimal solution found.")

solve_problem()
