
import gurobipy as gp

# Create a new model
m = gp.Model("Chair_Profit_Maximization")

# Create variables
leather_chairs = m.addVar(vtype=gp.GRB.CONTINUOUS, name="leather_chairs")  # Allowing fractional chairs for now
mesh_chairs = m.addVar(vtype=gp.GRB.CONTINUOUS, name="mesh_chairs")

# Set objective function
m.setObjective(250 * leather_chairs + 200 * mesh_chairs, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(500 * leather_chairs + 300 * mesh_chairs <= 50000, "Budget")
m.addConstr(leather_chairs + mesh_chairs <= 125, "Demand")
m.addConstr(leather_chairs >= 0, "NonNegativity_Leather")
m.addConstr(mesh_chairs >= 0, "NonNegativity_Mesh")


# Optimize model
m.optimize()

# Check for infeasibility
if m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    # Print optimal solution
    print("Optimal Solution:")
    print(f"Leather Chairs: {leather_chairs.x}")
    print(f"Mesh Chairs: {mesh_chairs.x}")
    print(f"Maximum Profit: ${m.objVal}")

    # Round down to integer solutions since we can't stock fractional chairs
    print("\nInteger Solution (Rounded Down):")
    print(f"Leather Chairs: {int(leather_chairs.x)}")
    print(f"Mesh Chairs: {int(mesh_chairs.x)}")
    
    # Calculate profit for the rounded-down solution
    rounded_profit = 250 * int(leather_chairs.x) + 200 * int(mesh_chairs.x)
    print(f"Rounded Down Profit: ${rounded_profit}")

