
from gurobipy import *

# Create a new model
m = Model("Chair_Optimization")

# Define variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="leather_chairs", lb=0)
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="mesh_chairs", lb=0)

# Objective function: Maximize profit
m.setObjective(250*x1 + 200*x2, GRB.MAXIMIZE)

# Constraints
m.addConstr(500*x1 + 300*x2 <= 50000, "Total Cost")
m.addConstr(x1 + x2 <= 125, "Total Demand")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution: {x1.varName} = {x1.x}, {x2.varName} = {x2.x}")
    print(f"Maximum profit: {m.objVal}")
else:
    print("No optimal solution found")
