
import gurobipy as gp

def solve_chair_problem():
    # Create a new model
    model = gp.Model("Chair_Problem")

    # Define variables
    x1 = model.addVar(name="leather_chairs", lb=0, vtype=gp.GRB.INTEGER)
    x2 = model.addVar(name="mesh_chairs", lb=0, vtype=gp.GRB.INTEGER)

    # Objective function: Maximize profit
    model.setObjective(250*x1 + 200*x2, gp.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(500*x1 + 300*x2 <= 50000, name="investment_constraint")
    model.addConstr(x1 + x2 <= 125, name="demand_constraint")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gp.GRB.OPTIMAL:
        print(f"Optimal solution found. Leather chairs: {x1.varValue}, Mesh chairs: {x2.varValue}")
    else:
        print("No optimal solution found.")

solve_chair_problem()
