
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("salad_optimization")

# Create variables
caesar = m.addVar(lb=0, vtype=GRB.INTEGER, name="caesar") # Number of caesar salads
house = m.addVar(lb=0, vtype=GRB.INTEGER, name="house")  # Number of house salads

# Set objective function
m.setObjective(5 * caesar + 8 * house, GRB.MAXIMIZE)

# Add constraints
m.addConstr(20 * caesar + 30 * house <= 2000, "lettuce_constraint") # Lettuce constraint
m.addConstr(house >= 3 * caesar, "popularity_constraint") # Popularity constraint
m.addConstr(caesar >= 8, "min_caesar_constraint") # Minimum caesar salads

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found:")
    print(f"Number of Caesar Salads: {caesar.x}")
    print(f"Number of House Salads: {house.x}")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

