
from gurobipy import *

# Create a new model
model = Model("Salad_Optimization")

# Define variables
x1 = model.addVar(vtype=GRB.INTEGER, name="Caesar_Salads", lb=0)
x2 = model.addVar(vtype=GRB.INTEGER, name="House_Salads", lb=0)

# Set the objective function
model.setObjective(5*x1 + 8*x2, GRB.MAXIMIZE)

# Add constraints
model.addConstr(20*x1 + 30*x2 <= 2000, "Lettuce_Constraint")
model.addConstr(x2 >= 3*x1, "House_vs_Caesar_Ratio")
model.addConstr(x1 >= 8, "Minimum_Caesar_Salads")

# Optimize the model
model.optimize()

# Print the results
if model.status == GRB.OPTIMAL:
    print(f"Optimal solution found:")
    print(f"Number of Caesar salads: {x1.x}")
    print(f"Number of House salads: {x2.x}")
    print(f"Maximum Profit: {model.objVal}")
else:
    print("No optimal solution found")
