
import gurobi

def solve_salad_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(lb=8, name="caesar_salads", vtype=gurobi.GRB.INTEGER)  # Minimum of 8 caesar salads
    x2 = model.addVar(name="house_salads", vtype=gurobi.GRB.INTEGER)

    # Objective function: Maximize 5*x1 + 8*x2
    model.setObjective(5*x1 + 8*x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(20*x1 + 30*x2 <= 2000, name="lettuce_constraint")
    model.addConstr(x2 >= 3*x1, name="popularity_constraint")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: Caesar salads = {x1.varValue}, House salads = {x2.varValue}")
    else:
        print("No optimal solution found")

solve_salad_problem()
