
import gurobipy as gp

# Create a new model
model = gp.Model("BakeryOptimization")

# Create decision variables
bagels = model.addVar(lb=0, name="bagels")  # Batches of bagels
croissants = model.addVar(lb=0, name="croissants")  # Batches of croissants

# Set objective function: Maximize profit
model.setObjective(7.5 * bagels + 5 * croissants, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(2 * bagels + 1.5 * croissants <= 2500, "mixer_hours")  # Mixer hours constraint
model.addConstr(3.5 * bagels + 2 * croissants <= 2500, "oven_hours")  # Oven hours constraint


# Optimize the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"  Batches of Bagels: {bagels.x}")
    print(f"  Batches of Croissants: {croissants.x}")
    print(f"  Total Profit: ${model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

