
import gurobipy as gp

# Create a new model
model = gp.Model("Joy_Bakery_Optimization")

# Define variables
x1 = model.addVar(name="bagels", lb=0)  # Number of batches of bagels
x2 = model.addVar(name="croissants", lb=0)  # Number of batches of croissants

# Objective function: Maximize profit
model.setObjective(7.5 * x1 + 5 * x2, gp.GRB.MAXIMIZE)

# Constraints
model.addConstr(2 * x1 + 1.5 * x2 <= 2500, name="dough_mixer_constraint")
model.addConstr(3.5 * x1 + 2 * x2 <= 2500, name="bake_oven_constraint")

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Number of batches of bagels: {x1.varValue}")
    print(f"Number of batches of croissants: {x2.varValue}")
    print(f"Maximum profit: ${model.objVal:.2f}")
else:
    print("The model is infeasible.")
