
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("furniture_store")

# Create variables
bookcases = m.addVar(vtype=GRB.CONTINUOUS, name="bookcases")
tables = m.addVar(vtype=GRB.CONTINUOUS, name="tables")


# Set objective function
m.setObjective(150 * bookcases + 200 * tables, GRB.MAXIMIZE)

# Add constraints
m.addConstr(15 * bookcases + 8 * tables <= 1200, "floor_space")
m.addConstr(bookcases >= 0.2 * (bookcases + tables), "bookcase_proportion")
m.addConstr(1200 * bookcases + 1500 * tables <= 50000, "capital")
m.addConstr(bookcases >= 0, "non_negativity_bookcases")  # Explicit non-negativity constraints
m.addConstr(tables >= 0, "non_negativity_tables")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal:.2f}")
    print(f"Number of bookcases: {bookcases.x:.2f}")
    print(f"Number of tables: {tables.x:.2f}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

