
from gurobipy import *

# Create a new model
m = Model("Furniture_Store_Optimization")

# Define variables
x1 = m.addVar(name='bookcases', vtype=GRB.INTEGER)
x2 = m.addVar(name='dining_tables', vtype=GRB.INTEGER)

# Set objective function
m.setObjective(150*x1 + 200*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(15*x1 + 8*x2 <= 1200, name='floor_space')
m.addConstr(x1 >= 0.20*(x1 + x2), name='bookcase_ratio')
m.addConstr(1200*x1 + 1500*x2 <= 50000, name='capital')

# Optimize model
m.optimize()

# Print results
for v in m.getVars():
    print(f'{v.varName}: {v.x}')
print(f'Objective: {m.objVal}')
