
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="bookcases", lb=0)
    x2 = model.addVar(name="dining_tables", lb=0)

    # Objective function
    model.setObjective(150 * x1 + 200 * x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(15 * x1 + 8 * x2 <= 1200, name="floor_space")
    model.addConstr(4 * x1 - x2 >= 0, name="bookcase_percentage")
    model.addConstr(1200 * x1 + 1500 * x2 <= 50000, name="capital")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Number of bookcases: {x1.varValue}")
        print(f"Number of dining tables: {x2.varValue}")
        print(f"Maximum profit: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
