
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("ticket_optimization")

# Create variables
premium = m.addVar(vtype=GRB.INTEGER, name="premium")
regular = m.addVar(vtype=GRB.INTEGER, name="regular")

# Set objective function
m.setObjective(50 * premium + 30 * regular, GRB.MAXIMIZE)

# Add constraints
m.addConstr(premium + regular == 500, "total_tickets")
m.addConstr(premium >= 100, "min_premium")
m.addConstr(regular >= 3 * premium, "regular_vs_premium")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal}")
    print(f"Number of premium tickets: {premium.x}")
    print(f"Number of regular tickets: {regular.x}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

