
from gurobipy import *

# Create a new model
m = Model("Ticket_Sales")

# Define variables
x1 = m.addVar(lb=0, vtype=GRB.INTEGER, name="premium_tickets")
x2 = m.addVar(lb=0, vtype=GRB.INTEGER, name="regular_tickets")

# Set the objective function
m.setObjective(50*x1 + 30*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 == 500, "total_tickets")
m.addConstr(x1 >= 100, "premium_minimum")
m.addConstr(x2 >= 3*x1, "regular_minimum")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Premium tickets: {x1.x}")
    print(f"Regular tickets: {x2.x}")
    print(f"Total profit: ${50*x1.x + 30*x2.x}")
else:
    print("No optimal solution found")
