
import gurobi

def solve_tourist_attraction_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(lb=0, name="premium_tickets", vtype=gurobi.GRB.INTEGER)  # Number of premium tickets
    x2 = model.addVar(lb=0, name="regular_tickets", vtype=gurobi.GRB.INTEGER)  # Number of regular tickets

    # Objective function: Maximize 50*x1 + 30*x2
    model.setObjective(50*x1 + 30*x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x1 + x2 <= 500, name="total_tickets")  # Total tickets sold
    model.addConstr(x1 >= 100, name="min_premium_tickets")  # Minimum premium tickets
    model.addConstr(x2 >= 3*x1, name="ratio_regular_to_premium")  # Ratio of regular to premium tickets

    # Solve the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Number of premium tickets: {x1.varValue}")
        print(f"Number of regular tickets: {x2.varValue}")
        print(f"Maximum profit: {50*x1.varValue + 30*x2.varValue}")
    else:
        print("No optimal solution found.")

solve_tourist_attraction_problem()
