
from gurobipy import Model, GRB

# Create a new model
m = Model("flight_profit")

# Create variables
first_class = m.addVar(vtype=GRB.INTEGER, name="first_class")
economy_class = m.addVar(vtype=GRB.INTEGER, name="economy_class")

# Set objective function
m.setObjective(150 * first_class + 350 * economy_class, GRB.MAXIMIZE)

# Add constraints
m.addConstr(first_class + economy_class <= 150, "total_tickets")
m.addConstr(first_class >= 20, "min_first_class")
m.addConstr(economy_class >= 3 * first_class, "economy_vs_first_class")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal}")
    print(f"Number of first-class tickets: {first_class.x}")
    print(f"Number of economy-class tickets: {economy_class.x}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

