
from gurobipy import *

# Create a new model
m = Model("Flight_Ticket_Optimization")

# Add variables
x1 = m.addVar(lb=0, vtype=GRB.INTEGER, name="first_class_tickets")
x2 = m.addVar(lb=0, vtype=GRB.INTEGER, name="economy_class_tickets")

# Set the objective function
m.setObjective(150*x1 + 350*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 <= 150, "total_tickets")
m.addConstr(x1 >= 20, "min_first_class")
m.addConstr(x2 >= 3*x1, "economy_vs_first_class")
m.addConstr(x1 >= 0, "non_negative_first_class")
m.addConstr(x2 >= 0, "non_negative_economy")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"First-class tickets: {x1.x}")
    print(f"Economy-class tickets: {x2.x}")
    print(f"Total profit: ${150*x1.x + 350*x2.x}")
else:
    print("No optimal solution found.")
