
import gurobi

def solve_flight_ticket_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(lb=0, name="first_class_tickets", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(lb=0, name="economy_class_tickets", vtype=gurobi.GRB.INTEGER)

    # Objective function: maximize 150*x1 + 350*x2
    model.setObjective(150*x1 + 350*x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x1 + x2 <= 150, name="total_tickets")
    model.addConstr(x1 >= 20, name="min_first_class")
    model.addConstr(x2 >= 3*x1, name="economy_vs_first_class")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"First-class tickets: {x1.varValue}")
        print(f"Economy-class tickets: {x2.varValue}")
        print(f"Max Profit: {150*x1.varValue + 350*x2.varValue}")
    else:
        print("No optimal solution found.")

solve_flight_ticket_problem()
