
import gurobipy as gp

# Create a new model
m = gp.Model("crop_optimization")

# Create variables
peas = m.addVar(lb=0, name="peas")  # Acres of peas
beans = m.addVar(lb=0, name="beans") # Acres of beans

# Set objective function
m.setObjective(100 * peas + 160 * beans, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(peas + beans <= 30, "land_constraint")
m.addConstr(30 * peas + 50 * beans <= 1300, "bug_spray_constraint")
m.addConstr(2 * peas + 1.5 * beans <= 50, "care_taking_constraint")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"  Acres of peas: {peas.x}")
    print(f"  Acres of beans: {beans.x}")
    print(f"  Maximum profit: ${m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

