
from gurobipy import *

# Create a new model
m = Model("Gardener_Optimization")

# Define variables
x1 = m.addVar(name="acres_of_peas", lb=0)
x2 = m.addVar(name="acres_of_beans", lb=0)

# Set the objective function
m.setObjective(100*x1 + 160*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(30*x1 + 50*x2 <= 1300, name="bug_spray_budget")
m.addConstr(2*x1 + 1.5*x2 <= 50, name="care_taking_time")
m.addConstr(x1 + x2 <= 30, name="total_land")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found.")
    print(f"Acreage of peas: {x1.x}")
    print(f"Acreage of beans: {x2.x}")
    print(f"Maximum profit: ${100*x1.x + 160*x2.x:.2f}")
else:
    print("No optimal solution found.")
