
import gurobi

def solve_gardener_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="peas", lb=0, ub=None)
    x2 = model.addVar(name="beans", lb=0, ub=None)

    # Objective function: Maximize 100*x1 + 160*x2
    model.setObjective(100*x1 + 160*x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x1 + x2 <= 30, name="total_acres")
    model.addConstr(30*x1 + 50*x2 <= 1300, name="bug_spray_budget")
    model.addConstr(2*x1 + 1.5*x2 <= 50, name="care_taking_hours")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal acres of peas: {x1.varValue}")
        print(f"Optimal acres of beans: {x2.varValue}")
        print(f"Maximal profit: {model.objVal}")
    else:
        print("The problem is infeasible")

solve_gardener_problem()
