
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("bookstore_optimization")

# Create variables
hardcover = m.addVar(vtype=GRB.INTEGER, name="hardcover")
paperback = m.addVar(vtype=GRB.INTEGER, name="paperback")

# Set objective function
m.setObjective(5 * hardcover + 2 * paperback, GRB.MAXIMIZE)

# Add constraints
m.addConstr(hardcover + paperback <= 500, "total_books")
m.addConstr(hardcover >= 50, "min_hardcover")
m.addConstr(paperback >= 5 * hardcover, "paperback_preference")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal}")
    print(f"Number of hardcover books: {hardcover.x}")
    print(f"Number of paperback books: {paperback.x}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

