
from gurobipy import *

# Create a new model
m = Model("Bookstore_Optimization")

# Define the variables
x1 = m.addVar(name='hardcover_books', vtype=GRB.INTEGER, lb=0)
x2 = m.addVar(name='paperback_books', vtype=GRB.INTEGER, lb=0)

# Set the objective function
m.setObjective(5*x1 + 2*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 <= 500, name='total_books')
m.addConstr(x1 >= 50, name='min_hardcover')
m.addConstr(x2 >= 5*x1, name='paperback_preference')

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Number of hardcover books: {x1.x}")
    print(f"Number of paperback books: {x2.x}")
    print(f"Maximum profit: ${5*x1.x + 2*x2.x:.2f}")
else:
    print("No optimal solution found.")
