
import gurobi

def solve_bookstore_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="hardcover_books", lb=0, ub=500, vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="paperback_books", lb=0, ub=500, vtype=gurobi.GRB.INTEGER)

    # Objective function: maximize 5*x1 + 2*x2
    model.setObjective(5*x1 + 2*x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x1 + x2 <= 500, name="total_books")
    model.addConstr(x1 >= 50, name="min_hardcover")
    model.addConstr(x2 >= 5*x1, name="paperback_preference")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: hardcover_books = {x1.varValue}, paperback_books = {x2.varValue}")
    else:
        print("The model is infeasible")

solve_bookstore_problem()
