
import gurobipy as gp

# Create a new model
model = gp.Model("Jelly Optimization")

# Create variables
blue_jelly = model.addVar(vtype=gp.GRB.CONTINUOUS, name="blue_jelly")  # Number of blue jelly pouches
red_jelly = model.addVar(vtype=gp.GRB.CONTINUOUS, name="red_jelly")  # Number of red jelly pouches


# Set objective function: Minimize cost
model.setObjective(5 * blue_jelly + 7 * red_jelly, gp.GRB.MINIMIZE)

# Add constraints
model.addConstr(2 * blue_jelly + 3 * red_jelly >= 30, "calcium_req")
model.addConstr(1 * blue_jelly + 2 * red_jelly >= 25, "potassium_req")
model.addConstr(3 * blue_jelly + 1 * red_jelly >= 30, "sodium_req")

# Non-negativity constraints are added implicitly by setting vtype to GRB.CONTINUOUS

# Optimize the model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution found. Objective value: {model.objVal}")
    print(f"Number of blue jelly pouches: {blue_jelly.x}")
    print(f"Number of red jelly pouches: {red_jelly.x}")
elif model.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status: {model.status}")

